// assets/js/app.js
// =======================================
//  ملف الجافاسكربت الرئيسي للنظام
//  PROG EGYPT SaaS
// =======================================

(function () {
    "use strict";

    // ================================
    //  1- كلاس الحقول داخل المودالات
    // ================================
    class InputData {
        async drawInput(id, label = "", type = "text", at = ".bodyModalPage", classInput = "col-12", attr = "") {
            main.chckLogin();
            const txt = `
                <div class="${classInput}">
                    <div class="form-group">
                        <label for="${id}" class="form-label">${label}</label>
                        <input type="${type}" class="form-control khedma-input" id="${id}" ${attr}>
                    </div>
                </div>
            `;
            $(at).append(txt);
        }

        async drawInputNumber(id, label = "", max, min, defaultValue = "", at = ".bodyModalPage", classInput = "col-12", attr = "") {
            const txt = `
                <div class="${classInput}">
                    <div class="form-group">
                        <label for="${id}">${label}</label>
                        <input type="number" min="${min}" max="${max}" value="${defaultValue}"
                               class="form-control khedma-input" id="${id}" ${attr}>
                    </div>
                </div>
            `;
            $(at).append(txt);
        }

        async drawInputWithFuntion(id, label = "", type = "text", typeFunction, functionCall, at = ".bodyModalPage", classInput = "col-12") {
            const txt = `
                <div class="${classInput}">
                    <div class="form-group">
                        <label for="${id}">${label}</label>
                        <input type="${type}" ${typeFunction}="${functionCall}" class="form-control khedma-input" id="${id}">
                    </div>
                </div>
            `;
            $(at).append(txt);
        }

        async drawInputCheckbox(id, label = "", value = "", at = ".bodyModalPage", classInput = "col-12") {
            const txt = `
                <div class="${classInput}">
                    <div class="form-check mt-1 mb-2" dir="rtl">
                        <input type="checkbox" value="${value}" class="form-check-input" id="${id}">
                        <label class="form-check-label" for="${id}">${label}</label>
                    </div>
                </div>
            `;
            $(at).append(txt);
        }

        async buttonModal(label, afterClick = "") {
            if (label === "0") {
                $('.doneButtonModalPage').hide();
            } else {
                $('.doneButtonModalPage')
                    .show()
                    .text(label)
                    .attr("onclick", afterClick);
            }
        }

        async drawTextAreaInput(id, label = "", at = ".bodyModalPage", classInput = "col-12") {
            const txt = `
                <div class="${classInput}">
                    <div class="form-group">
                        <label for="${id}">${label}</label>
                        <textarea class="form-control khedma-input" id="${id}" rows="3"></textarea>
                    </div>
                </div>
            `;
            $(at).append(txt);
        }

        async drawSelectInput(id, dataSelect, label = "", valueOption, textOption, at = ".bodyModalPage", classInput = "col-12", callBack = "") {
            return new Promise(async (resolve) => {
                let option = "";

                if (Array.isArray(dataSelect)) {
                    // لو البيانات array جاهزة
                    for (let i = 0; i < dataSelect.length; i++) {
                        option += `<option value="${valueOption[i]}">${textOption[i]}</option>`;
                    }
                } else {
                    // لو البيانات جايه من السيرفر
                    await main.getData("getDataSelect", dataSelect, main.idTypePage);
                    for (let i = 0; i < main.dataResponse.length; i++) {
                        option += `<option value="${main.dataResponse[i][valueOption]}">${main.dataResponse[i][textOption]}</option>`;
                    }
                }

                const txt = `
                    <div class="${classInput}">
                        <div class="form-group">
                            <label for="${id}">${label}</label>
                            <select class="form-control khedma-input" id="${id}" ${callBack}>
                                ${option}
                            </select>
                        </div>
                    </div>
                `;

                $(at).append(txt);
                resolve();
            });
        }

        async addButton(label, callBack, at, classBtn) {
            $(at).append(`
                <button type="button" class="btn btn-primary ${classBtn}" onclick="${callBack}">
                    ${label}
                </button>
            `);
        }

        async addCustumTag(html, at = ".bodyModalPage") {
            return new Promise((resolve) => {
                $(at).append(html);
                resolve();
            });
        }
    }

    // نعرّف اوبجيكت عام تقدر تستخدمه في كل المشروع
    window.inputData = new InputData();

    // ================================
    //  2- دوال الـ NAVBAR / SIDEBAR
    // ================================
    window.setActiveNav = function (id) {
        $(".khedma-nav-links .nav-link").removeClass("active");
        $("#" + id).addClass("active");
    };

    window.setActiveSidebar = function (id) {
        $(".md-nav-link").removeClass("active");
        $("#" + id).addClass("active");
    };

    // ================================
    //  3- أكواد تهيئة عامة عند تحميل الصفحة
    // ================================
    $(function () {
        // مثال: اجعل أول عنصر في الـ sidebar active لما الصفحة تفتح
        // setActiveSidebar('side_dashboard');

        // ممكن تضيف أي إعدادات عامة هنا
    });

})();
